import { useState, useEffect } from "react";
import axios from "axios";
import { useNavigate } from "react-router-dom";
import { SearchForm } from "@/components/layout/search-form";
import { Button } from "@/components/ui/button";
import { TableCaption, TableHeader, TableRow, TableHead, TableBody, TableCell } from "@/components/ui/table";
import { Table } from "@/components/ui/table";

export default function SubEmpresas() {
  const [array, setArray] = useState([]); // Inicialmente vazio
  const [loading, setLoading] = useState(true); // Para mostrar loading


  // const [error, setError] = useState(null); // Para tratar erros
  const [error] = useState(null);


  const navigate = useNavigate();

  useEffect(() => {
    const fetchCompanies = async () => {
      const token = localStorage.getItem('token'); // Recupera o token do localStorage
      if (!token) {
        navigate('/login');
        return;
      }

      try {
        const response = await axios.get('http://localhost:5002/api/subcompanies', {
          headers: {
            Authorization: `Bearer ${token}`, // Inclui o token no cabeçalho
          },
        });

        setArray(response.data); // Atualiza o estado com os dados recebidos
      } catch (err) {
        console.error(err);
        // setError('Erro ao carregar dados');
      } finally {
        setLoading(false); // Oculta o loading
      }
    };

    fetchCompanies();
  }, []); // Executa apenas uma vez quando o componente é montado

  if (loading) {
    return <div>Carregando...</div>; // Mensagem enquanto está carregando
  }

  if (error) {
    return <div>{error}</div>; // Mensagem de erro
  }

  return (
    <div>
      <div className="justify-self-start text-left mt-2 p-5 w-full">
        <div className="flex flex-row gap-4 items-center">
          <div className="flex-1">

            <h1 className="text-2xl font-bold">Sub-Empresas</h1>
            <p className="mt-2">Relatorio de todas as sub-empresas registradas.</p>
            <Button variant="outline" className="mt-4">Adicionar Sub-Empresa</Button>
          </div>
          <SearchForm  className="place-self-start" />
        </div>
      </div>

      <div className="flex-1 p-5">
        <Table>
          <TableCaption>Lista de empresas registradas no sistema.</TableCaption>
          <TableHeader>
            <TableRow>
              <TableHead className="pl-20">Subempresa</TableHead>
              <TableHead>Código</TableHead>
              <TableHead>Criado em</TableHead>
            </TableRow>
          </TableHeader>
          <TableBody>

            
            {/*array.map((subempresa, index) => (*/}
            {array.map((index) => (
              <TableRow key={index}>


                <TableCell className="pl-20 font-medium text-left">Nome</TableCell>
                {/* <TableCell className="pl-20 font-medium text-left">{subempresa.nome}</TableCell>
                <TableCell className="pl-20 font-medium text-left">{subempresa.codigo}</TableCell>
                <TableCell className="pl-20 font-medium text-left">{subempresa.criado_em}</TableCell> */}


              </TableRow>
            ))}
          </TableBody>
        </Table>
      </div>
    </div>
  )
}