import { useState, useEffect } from "react";
import axios from "axios";
import { useNavigate } from "react-router-dom";
import { SearchForm } from "@/components/layout/search-form";
import { Button } from "@/components/ui/button";
import {
  Table,
  TableBody,
  TableCaption,
  TableCell,
  TableHead,
  TableHeader,
  TableRow,
} from "@/components/ui/table"
// import { Outlet } from "react-router";
import { Eye, Pencil, Trash } from "lucide-react";

export default function Empresas() {
  const [array, setArray] = useState([]); // Inicialmente vazio
  const [loading, setLoading] = useState(true); // Para mostrar loading


//  const [error, setError] = useState(null); // Para tratar erros
  const [error] = useState(null);


  const navigate = useNavigate();

  useEffect(() => {
    const fetchCompanies = async () => {
      const token = localStorage.getItem('token'); // Recupera o token do localStorage
      if (!token) {
        navigate('/login');
        return;
      }

      try {
        const response = await axios.get('http://localhost:5002/api/companies', {
          headers: {
            Authorization: `Bearer ${token}`, // Inclui o token no cabeçalho
          },
        });

        setArray(response.data); // Atualiza o estado com os dados recebidos
      } catch (err) {
        console.error(err);
        // setError('Erro ao carregar dados');
      } finally {
        setLoading(false); // Oculta o loading
      }
    };

    fetchCompanies();
  }, []); // Executa apenas uma vez quando o componente é montado

  if (loading) {
    return <div>Carregando...</div>; // Mensagem enquanto está carregando
  }

  if (error) {
    return <div>{error}</div>; // Mensagem de erro
  }

  return (
    <div>
      <div className="justify-self-start text-left mt-2 p-5 w-full">
        <div className="flex flex-row gap-4 items-center">
          <div className="flex-1">
            <h1 className="text-2xl font-bold">Empresas</h1>
            <p className="mt-2">Relatorio de todas as empresas registradas.</p>
            <Button
              variant="outline"
              className="mt-4"
              //onClick={() =>
                // setArray([
                //   ...array,
                //   { a: "Nova Empresa", b: "B6", c: "C6", d: "D6" },
                // ])
              //}
            >
              Adicionar Empresa
            </Button>
          </div>
          <SearchForm className="place-self-start" />
        </div>
      </div>

      <div className="flex-1 p-5">
        <Table>
          <TableCaption>Lista de empresas registradas no sistema.</TableCaption>
          <TableHeader>
            <TableRow>
              <TableHead className="pl-20">Empresa</TableHead>
              <TableHead>CNPJ</TableHead>
            </TableRow>
          </TableHeader>
          <TableBody>


            {/*array.map((empresa, index) => (*/}
            {array.map((index) => (


              <TableRow key={index} className="group">
                {/* <TableCell className="pl-20 font-medium text-left">{empresa.nome}</TableCell> */}
                <TableCell className="text-left">00.000.000/0000-00</TableCell>
                <TableCell>
                  <div className="invisible flex text-center flex-row justify-center group-hover:visible">
                    <Eye />
                    <Pencil className="ml-3 mr-3" />
                    <Trash />
                  </div>
                </TableCell> 
              </TableRow>
            ))}
          </TableBody>
        </Table>
      </div>
    </div>
  )
}