import Dispatcher from 'undici-types/dispatcher'
import { setGlobalDispatcher, getGlobalDispatcher } from 'undici-types/global-dispatcher'
import { setGlobalOrigin, getGlobalOrigin } from 'undici-types/global-origin'
import Pool from 'undici-types/pool'
import { RedirectHandler, DecoratorHandler } from 'undici-types/handlers'

import BalancedPool from 'undici-types/balanced-pool'
import Client from 'undici-types/client'
import H2CClient from 'undici-types/h2c-client'
import buildConnector from 'undici-types/connector'
import errors from 'undici-types/errors'
import Agent from 'undici-types/agent'
import MockClient from 'undici-types/mock-client'
import MockPool from 'undici-types/mock-pool'
import MockAgent from 'undici-types/mock-agent'
import { MockCallHistory, MockCallHistoryLog } from 'undici-types/mock-call-history'
import mockErrors from 'undici-types/mock-errors'
import ProxyAgent from 'undici-types/proxy-agent'
import EnvHttpProxyAgent from 'undici-types/env-http-proxy-agent'
import RetryHandler from 'undici-types/retry-handler'
import RetryAgent from 'undici-types/retry-agent'
import { request, pipeline, stream, connect, upgrade } from 'undici-types/api'
import interceptors from 'undici-types/interceptors'

export * from 'undici-types/util'
export * from 'undici-types/cookies'
export * from 'undici-types/eventsource'
export * from 'undici-types/fetch'
export * from 'undici-types/formdata'
export * from 'undici-types/diagnostics-channel'
export * from 'undici-types/websocket'
export * from 'undici-types/content-type'
export * from 'undici-types/cache'
export { Interceptable } from 'undici-types/mock-interceptor'

export { Dispatcher, BalancedPool, Pool, Client, buildConnector, errors, Agent, request, stream, pipeline, connect, upgrade, setGlobalDispatcher, getGlobalDispatcher, setGlobalOrigin, getGlobalOrigin, interceptors, MockClient, MockPool, MockAgent, MockCallHistory, MockCallHistoryLog, mockErrors, ProxyAgent, EnvHttpProxyAgent, RedirectHandler, DecoratorHandler, RetryHandler, RetryAgent, H2CClient }
export default Undici

declare namespace Undici {
  const Dispatcher: typeof import('undici-types/dispatcher').default
  const Pool: typeof import('undici-types/pool').default
  const RedirectHandler: typeof import ('undici-types/handlers').RedirectHandler
  const DecoratorHandler: typeof import ('undici-types/handlers').DecoratorHandler
  const RetryHandler: typeof import ('undici-types/retry-handler').default
  const BalancedPool: typeof import('undici-types/balanced-pool').default
  const Client: typeof import('undici-types/client').default
  const H2CClient: typeof import('undici-types/h2c-client').default
  const buildConnector: typeof import('undici-types/connector').default
  const errors: typeof import('undici-types/errors').default
  const Agent: typeof import('undici-types/agent').default
  const setGlobalDispatcher: typeof import('undici-types/global-dispatcher').setGlobalDispatcher
  const getGlobalDispatcher: typeof import('undici-types/global-dispatcher').getGlobalDispatcher
  const request: typeof import('undici-types/api').request
  const stream: typeof import('undici-types/api').stream
  const pipeline: typeof import('undici-types/api').pipeline
  const connect: typeof import('undici-types/api').connect
  const upgrade: typeof import('undici-types/api').upgrade
  const MockClient: typeof import('undici-types/mock-client').default
  const MockPool: typeof import('undici-types/mock-pool').default
  const MockAgent: typeof import('undici-types/mock-agent').default
  const MockCallHistory: typeof import('undici-types/mock-call-history').MockCallHistory
  const MockCallHistoryLog: typeof import('undici-types/mock-call-history').MockCallHistoryLog
  const mockErrors: typeof import('undici-types/mock-errors').default
  const fetch: typeof import('undici-types/fetch').fetch
  const Headers: typeof import('undici-types/fetch').Headers
  const Response: typeof import('undici-types/fetch').Response
  const Request: typeof import('undici-types/fetch').Request
  const FormData: typeof import('undici-types/formdata').FormData
  const caches: typeof import('undici-types/cache').caches
  const interceptors: typeof import('undici-types/interceptors').default
  const cacheStores: {
    MemoryCacheStore: typeof import('undici-types/cache-interceptor').default.MemoryCacheStore,
    SqliteCacheStore: typeof import('undici-types/cache-interceptor').default.SqliteCacheStore
  }
}
